package gov.va.med.mhv.common.essapi.exception;

import gov.va.med.mhv.common.essapi.cache.CacheHandler;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.transfer.ErrorTO;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;

public class WebApplicationMapper implements ExceptionMapper<WebApplicationException> {
    public Response toResponse(WebApplicationException ex) {
    	ResponseBuilderImpl builder = new ResponseBuilderImpl();
		builder.status(400);
		ErrorTO error = CacheHandler.getInstance().getError();
		
		if( error == null ) {
			error = new ErrorTO(ErrorEnum.UNKNOWN_99,ex.getMessage());
			CacheHandler.getInstance().setError(error);
		}
		
		Response responseException = builder.entity(error).build();
    	return responseException;
    }
}
